# ACF Plugin v1.7.0.16 Release Notes

Welcome to the latest release of the ACF Plugin, version 1.7.0.8. This version marks a significant advancement in our commitment to quality and reliability. Below is an overview of the enhancements and fixes included in this release.

## Key Improvements

### Quality Assurance Enhancements
- Our team has made substantial efforts in the quality assurance department to ensure the highest standards. The ACF compiler, integral to the plugin, now more accurately predicts stack usage for the runtime, focusing on data types involved in various operations.
- We've implemented automated testing and detailed logging, leading to the identification and resolution of several critical issues. These efforts have significantly enhanced the overall stability and quality of the plugin.

### XML and JSON Data Handling
- The handling of complex XML and JSON data types has been meticulously tested on intricate structures. External validation has been conducted to guarantee that all operations within the plugin perform as expected.

## MacOS compatibility: 

- Intel Mac: From MacOS 10.13 High Sierra
- Arm (Silicon) Mac (M1, M2...) : From MacOS 12.3 Monterey
- All architectures can run up to the current MacOS 14.2 Somono

## Version History

### 1.7.0.16

- Two new ACF functions, `create_hash` and `create_hmac` for generating message digests for all the methods: MD5, SHA1, SHA256, SHA384, and SHA512. Documentation can be found on the following WEB-page: [horneks.no/manuals/ACF/createhashfunction.html](https://horneks.no/manuals/ACF/createhashfunction.html)

### 1.7.0.15

- Implemented new language grammar features: 
  - Conditional expressions (see [Syntax differences, conditional expressions](https://horneks.no/manuals/ACF/somesyntaxdifferences.html#toc1-2-0) )
  - Case ... end case structures. (see [Case structures](https://horneks.no/manuals/ACF/programmingbasics.html#toc1-7-3))
  - `break` statement to exit loops and case constructs. A break that is placed inside an if-construct will break out of the loop surrounding it. Breaks inside case constructs break out of the case and continue execution after `end case`. The break statement exits any type of loop construct being for, while, or repeat until. 

### 1.7.0.12

- The `send_email` function has been enhanced to encode display names in email addresses and the subject line, ensuring compliance with email standards. Additionally, we've refined the processing of lengthy subject lines by appropriately splitting them across multiple lines in the mail headers. For emails with numerous recipients in the "To" or "Cc" fields, our improved implementation now effectively splits these lines following RFC standards. The encoding utilized is UTF-8 with Quoted Printable. It's worth noting that the encoding of different body parts was already accurately implemented starting from version 1.7.0.9.

### 1.7.0.11

- Fixed bug in send_email where mail contained several inline images. The styling of the HTML mail was incorrect. 

### 1.7.0.10

- Fixed a little bug in the `send_email` implementation. It did not recognize correctly the email addresses on the form `name <myemail@example.com>` , only the naked emails without the name in front. 
- Updated the TextMate editor bundle to correctly handle indentation and added some new language functions. It is in the download DMG. 

### 1.7.0.9

- Implemented send_email function, according to the web page at: 
  https://horneks.no/manuals/ACF/sendane-mailfromtheacfplugin.html

### 1.7.0.8
- Resolved SSL issues on macOS Sonoma by updating the cURL and OpenSSL libraries. Previously, the plugin used cURL with LibreSSL, which was compatible with earlier macOS versions but not with Sonoma. The plugin now utilizes cURL with OpenSSL 3.0.9. This update is essential for the proper functioning of HTTP_GET, HTTP_POST, and document service functions. 

### 1.7.0.7
- Plugin and installer dmg is now Notarized @ apple, so there should be no issues installing the plugin on newer MacOS releases. Tested with MacOS Sonomoa 14.2
- Minor adjustments to XML implementation for improved handling of intermediate XML documents. When attaching intermediate XMLs to a master document, if the intermediate document's root element is "intermediateRoot", only its child elements are attached. The function for adding key/value pair lists now encapsulates the list within an "intermediateRoot" element. Conversely, other ACF functions return XML nodes without this wrapper. This approach greatly facilitates the construction of complex XML structures, allowing for seamless assembly of disparate parts into a unified master document. This implementation strategy is essential due to XML's limitation of only allowing a single root element per document. Further details will be provided in the documentation.

### 1.7.0.6
- The quality assurance work on the plugin mentioned above. 

### 1.7.0.5
- Minor adjustments to JSON functionality for alignment with XML implementation.

### 1.7.0.4
- Enhanced debugging of XML functions.

### 1.7.0.3
- Introduction of XML support functions and data type.
- Seamless XML to JSON conversion capabilities.

### 1.7.0.2b
- Incorporation of JSON support as detailed at [ACF JSON Data Type Documentation](https://horneks.no/manuals/ACF/jsondatatypeintheacflanguage.html).

### 1.7.0.1
- Enhanced document service with one-time password security.
- Introduction of Confirm, Alert, and Request functions for exception handling.
- Robust TRY/CATCH/TRY AGAIN logic for exceptions.

### 1.7.0.0
- New HTTP_Get and HTTP_Post functions.
- Enhanced OTP functions for Two-factor authentication.
- Advanced SQL functionality with placeholders.
- Updated MySQL compatibility.
- Refined Document Service functions.
- New BASE64_ENCODE, BASE32_ENCODE, BASE64_DECODE, BASE32_DECODE functions.

## Bug Fixes

- Addressed issues with compiling nameless packages. Nameless packages are now labeled "STD".
- Overhauled document service for improved stability, particularly in handling unusual parameters.
- Implemented 'List_files', absent in version 1.6.2.
- Introduced 'Delete_directory', though usage advisories apply due to potential risks with incorrect path specifications.

## Documentation

For detailed information and guidance, visit our [online documentation](https://horneks.no/manuals/ACF/index.html).

Additionally, an offline version of the documentation, as of 09.12.2023, is included in this download. Start with the `index.html` file at the top of the archive for offline reference.

---

Your feedback and suggestions are invaluable to us. If you have any thoughts or concerns, especially regarding features like 'Delete_directory', we welcome your input. Thank you for choosing the ACF Plugin!